/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
CSkeleton cskel;
Mesh     *mesh;

Window   window;
Text     text  [5];
Slider   slider[4];
CheckBox blink;
/******************************************************************************/
void InitPre()
{
   App.name="Facial Animation";
   App.flag=APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).ambPower(0.2).shdMode(SHD_MAP_HW).shdSoft(1).shdMapSize(1024).hpRt(true);
   ViewportFull.range=8;
}
/******************************************************************************/
Bool Init()
{
   // camera
   Cam.dist=0.4;
   Cam.at.set(0,0.75,0);
   Cam.yaw=PI;
   Cam.setSpherical().set();

   // sun
   Sun.set(*Gfxs("gfx/sky/sun.gfx"));
   Sun.pos  =!Vec(1,1,3);
   Sun.power=1-D.ambPower();

   // sky
   Sky.set();

   // character
   cskel.create("obj/chr/human/0.skel",1.8);
   mesh=Meshs  ("obj/chr/human/0.mesh");

   // gui
   Gui   +=window .create(Rect_R(D.w(),0,0.49,0.50),"Expressions");
   window+=text[0].create(Vec2(0.13,-0.05),"Angry"     ); window+=slider[0].create(Rect_L(0.26,-0.05,0.2 ,0.05));
   window+=text[1].create(Vec2(0.13,-0.13),"Astonished"); window+=slider[1].create(Rect_L(0.26,-0.13,0.2 ,0.05));
   window+=text[2].create(Vec2(0.13,-0.21),"Sad"       ); window+=slider[2].create(Rect_L(0.26,-0.21,0.2 ,0.05));
   window+=text[3].create(Vec2(0.13,-0.29),"Smile"     ); window+=slider[3].create(Rect_L(0.26,-0.29,0.2 ,0.05));
   window+=text[4].create(Vec2(0.13,-0.37),"Blink"     ); window+=blink    .create(Rect_L(0.26,-0.37,0.05,0.05),true);

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Gui.update();

   // animate
   Flt time=Tm.time();
   cskel.clear  ()
        .animate("anim/face/angry.anim"     ,time,slider[0]())
        .animate("anim/face/astonished.anim",time,slider[1]())
        .animate("anim/face/sad.anim"       ,time,slider[2]())
        .animate("anim/face/smile.anim"     ,time,slider[3]());

   if(blink())
   {
      Flt blend=Frac(time,3); // blink every      3   seconds
          blend/=0.1;         // blink duration = 0.1 seconds
      if( blend>1)blend=2-blend;
      cskel.animate("anim/face/blink.anim",time,blend,true);
   }

   cskel.updateMatrix(MatrixIdentity)
        .updateVelocities();

   if(!Gui.window_lit && Ms.b(0))CamHandle(0.01,10,CAMH_ZOOM|CAMH_ROT);

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID  :
      case RM_SHD_MAP:
         mesh->draw(cskel);
      break;
   }
}
void Draw()
{
   Renderer(Render);
   Gui.draw();
}
/******************************************************************************/
